#include "meson-subsample.h"

struct _MesonSubSample
{
  MesonSample parent_instance;

  gchar *msg;
};

G_DEFINE_TYPE (MesonSubSample, meson_sub_sample, MESON_TYPE_SAMPLE)

enum {
  PROP_0,
  PROP_MSG,
  LAST_PROP
};

static GParamSpec *gParamSpecs [LAST_PROP];

/**
 * meson_sub_sample_new:
 * @msg: The message to set.
 *
 * Allocates a new #MesonSubSample.
 *
 * Returns: (transfer full): a #MesonSubSample.
 */
MesonSubSample *
meson_sub_sample_new (const gchar *msg)
{
  g_return_val_if_fail (msg != NULL, NULL);

  return g_object_new (MESON_TYPE_SUB_SAMPLE,
                       "message", msg,
                       NULL);
}

static void
meson_sub_sample_finalize (GObject *object)
{
  MesonSubSample *self = (MesonSubSample *)object;

  g_clear_pointer (&self->msg, g_free);

  G_OBJECT_CLASS (meson_sub_sample_parent_class)->finalize (object);
}

static void
meson_sub_sample_get_property (GObject    *object,
                           guint       prop_id,
                           GValue     *value,
                           GParamSpec *pspec)
{
  MesonSubSample *self = MESON_SUB_SAMPLE (object);

  switch (prop_id)
    {
    case PROP_MSG:
      g_value_set_string (value, self->msg);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
meson_sub_sample_set_property (GObject      *object,
                           guint         prop_id,
                           const GValue *value,
                           GParamSpec   *pspec)
{
  MesonSubSample *self = MESON_SUB_SAMPLE (object);

  switch (prop_id)
    {
    case PROP_MSG:
      self->msg = g_value_dup_string (value);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
meson_sub_sample_class_init (MesonSubSampleClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  object_class->finalize = meson_sub_sample_finalize;
  object_class->get_property = meson_sub_sample_get_property;
  object_class->set_property = meson_sub_sample_set_property;

  gParamSpecs [PROP_MSG] =
    g_param_spec_string ("message",
                         "Message",
                         "The message to print.",
                         NULL,
                         (G_PARAM_READWRITE |
                          G_PARAM_CONSTRUCT_ONLY |
                          G_PARAM_STATIC_STRINGS));

  g_object_class_install_properties (object_class, LAST_PROP, gParamSpecs);
}

static void
meson_sub_sample_init (MesonSubSample *self)
{
}

/**
 * meson_sub_sample_print_message:
 * @self: a #MesonSubSample.
 *
 * Prints the message.
 *
 * Returns: Nothing.
 */
void
meson_sub_sample_print_message (MesonSubSample *self)
{
  g_return_if_fail (MESON_IS_SUB_SAMPLE (self));

  g_print ("Message: %s\n", self->msg);
}
